/******************************************************************************
#ifdef PADN_DOC
 * %Id: tsd_bridge_data.h,v 1.1 2013/01/23 01:15:09 tanke Exp $
#endif
 *
 * FileName		:tsd_bridge_data.h
 *
 * Description	:Data definition header for bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef TSD_BRIDGEDATA_H
#define TSD_BRIDGEDATA_H


#define TSD_MAX_FD_NAME 256

#define TSD_MAX_SECF 224
#define TSD_MAX_PESF 112
#define TSD_MAX_REQF 224

#define TSD_PAT_MAXSIZE 1024
#define TSD_PMT_MAXSIZE 1024
#define TSD_PMT_MAXNUM 8
#define TSD_SIT_MAXSIZE 4096

#define TSD_SEC_FILTER_MAXLEN 16
#define TSD_PES_FILTER_MAXLEN 16

#define TSD_CBCINIT_MAXLEN 32
#define TSD_SYSKEY_MAXLEN 32

#define TSD_DSCKEY_MAXLEN 24

/* Please check max port num in "mss_config.h" */
/* and max hsc resource on LSI SPEC.           */
#define TSD_TSI_MAX 5
#define TSD_HSO_MAX 2
#define TSD_MBI_MAX 4 /* HSC_R351 */
#define TSD_INPUT_MAX TSD_TSI_MAX+TSD_MBI_MAX
#define TSD_MBO_MAX 5
#define TSD_OUTPUT_MAX TSD_HSO_MAX+TSD_MBO_MAX
#define TSD_DSC_MAX 32
#define TSD_HED_MAX 32


#define TSD_SEC_MAX_LEN 4096
#define TSD_PESP_MAX_LEN 1024*32

#define TSD_MAX_PENTRY 160/* HSC_R352 */

#define TSD_PKTTYPE_MAX 8/* HSC_R325 */

#define TSD_INVALID8 0xFF
#define TSD_INVALID16 0xFFFF
#define TSD_INVALID32 0xFFFFFFFF

/* for system/data report function */
typedef enum _tsd_rpt_type_t{
	TSD_RPT_TYPE_SIOVWPAT,
	TSD_RPT_TYPE_SIOVWPMT,
	TSD_RPT_TYPE_SIOVWSIT,
	TSD_RPT_TYPE_TSINPUT,
	TSD_RPT_TYPE_TSOUTPUT,
	TSD_RPT_TYPE_AVOUTPUT,
	TSD_RPT_TYPE_PID
}tsd_rpt_type_t;

typedef struct {
    int cmd;
    int (*handler)(int,unsigned int,void *);
} tsd_command_t;

/*
 * Structs
 */
typedef struct _tsd_fifo_t {
	unsigned long top;
	unsigned long bottom;
	unsigned long begin;
	unsigned long end;
} tsd_fifo_t;

typedef struct _tsd_buf_t {
	unsigned char	state;
	unsigned long	saddr;
	unsigned long	eaddr;
	unsigned long	raddr;
	unsigned long	waddr;
	unsigned long	caddr;
	unsigned long	size;
	unsigned char	rate;
	unsigned long	info;
} tsd_buf_t;

/* tsdInitTsiput */
struct tsd_init_tsinput_t {
	int error;
	unsigned long tsin_port;
	unsigned long stcout_port;
	unsigned short stream;
};

/* tsdChangeStcoutTsinput */
struct tsd_change_stcout_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long stcout_port;
};

/* tsdChangeRateTsinput */
struct tsd_change_rate_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned char rate;
	unsigned char sync;
};

/* tsdSetBufTsinput */
struct tsd_set_buf_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long saddr;
	unsigned long eaddr;
	unsigned char loop;
	unsigned long mask;
};

/* tsdUpdateSizeTsinput */
struct tsd_update_size_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long size;
};

/* tsdUpdateWaddrTsinput */
struct tsd_update_waddr_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long waddr;
};

/* tsdUpdateRaddrTsinput */
struct tsd_update_raddr_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long raddr;
};

/* tsdUpdateCaddrTsinput */
struct tsd_update_caddr_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long caddr;
};

/* tsdGetBufStatusTsinput */
struct tsd_get_buf_status_tsinput_arg_t {
	int error;
	unsigned long tsin_port;
	tsd_buf_t buf;
};

/* tsdStartAvoutput */
struct tsd_start_avoutput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long avout_port;
	unsigned long mode;
};

/* tsdStartAvoutput */
struct tsd_stop_avoutput_arg_t {
	int error;
	unsigned long tsin_port;
	unsigned long avout_port;
};

/*
 * tsdStartTsinput, tsdStopTsinput
 * tsdFreePidAllTsoutput
 */
struct tsd_input_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long tsout_port;
};

/*
 * tsdAllocatePidVideo, tsdAllocatePidAudio,
 * tsdAllocatePidPcr, tsdAllocatePidSection,
 * tsdAllocatePidPespacket, tsdAllocatePidTsoutput
 * tsdAllocatePidTspacket
 */
struct tsd_alloc_pid_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long tsout_port;
	unsigned long out_port;
	unsigned short pid;
	unsigned long length;
	unsigned char type;
	unsigned char desc;
	unsigned long entry;
};

/*
 * tsdChangeStcoutPcr
 */
struct tsd_change_stcout_pcr_arg_t{
  int error;
  unsigned long pcrentry;
  unsigned long stcout_port;
};

/*
 * tsdFreePidVideo, tsdFreePidAudio,
 * tsdStartVideo, tsdStartAudio,
 * tsdStopVideo, tsdStopAudio,
 * tsdFreePidPcr, tsdRequestPcr,
 * tsdCancelPcr, tsdFreePidSection,
 * tsdFreePidPespacket, tsdFreeDescramble
 * tsdFreePidTsoutput, tsdStartPidTsoutput,
 * tsdStopPidTsoutput,
 */
struct tsd_entry_arg_t{
	int error;
	unsigned long entry;
};

/* tsdRequestSection */
struct tsd_request_sec_arg_t{
	int error;
	unsigned long pidentry;
	unsigned char filter[TSD_SEC_FILTER_MAXLEN];
	unsigned char mask[TSD_SEC_FILTER_MAXLEN];
	unsigned short length;
	unsigned char exfilter[TSD_SEC_FILTER_MAXLEN];
	unsigned char exmask[TSD_SEC_FILTER_MAXLEN];
	unsigned short exlength;
	unsigned long tag;
	short reqid;
	unsigned char flt_null_flg;
	unsigned char msk_null_flg;
	unsigned char e_flt_null_flg;
	unsigned char e_msk_null_flg;
};

/*
 * tsdCancelSection, tsdCancelPespacket
 * tsdCancelTsinputStatus, tsdCancelDataStatus
 */
struct tsd_reqid_arg_t{
	int error;
	short reqid;
};

/* tsdUpdateSection */
struct tsd_update_sec_arg_t{
	int error;
	short reqid;
	unsigned char filter[TSD_SEC_FILTER_MAXLEN];
	unsigned char mask[TSD_SEC_FILTER_MAXLEN];
	unsigned char exfilter[TSD_SEC_FILTER_MAXLEN];
	unsigned char exmask[TSD_SEC_FILTER_MAXLEN];
	unsigned long tag;
	unsigned char flt_null_flg;
	unsigned char msk_null_flg;
	unsigned char e_flt_null_flg;
	unsigned char e_msk_null_flg;
};

/* tsdRequestPespacket */
struct tsd_request_pesp_arg_t{
	int error;
	unsigned long pidentry;
	unsigned char filter[TSD_PES_FILTER_MAXLEN];
	unsigned char mask[TSD_PES_FILTER_MAXLEN];
	unsigned short length;
	unsigned long tag;
	short reqid;
	unsigned char flt_null_flg;
	unsigned char msk_null_flg;
};

/* tsdUpdatePespacket */
struct tsd_update_pesp_arg_t{
	int error;
	short reqid;
	unsigned char filter[TSD_PES_FILTER_MAXLEN];
	unsigned char mask[TSD_PES_FILTER_MAXLEN];
	unsigned long tag;
	unsigned char flt_null_flg;
	unsigned char msk_null_flg;
};

/* tsdInitDescrambler */
struct tsd_init_desc_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned short type;
	unsigned char cbcinit[TSD_CBCINIT_MAXLEN];
	unsigned char syskey[TSD_SYSKEY_MAXLEN];
};

/* tsdAllocateDescrambler */
struct tsd_alloc_desc_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned char mode;
	unsigned long descentry;
};

/* tsdChangeDescrambleKey */
struct tsd_change_desc_key_arg_t{
	int error;
	unsigned long descentry;
	unsigned char even[TSD_DSCKEY_MAXLEN];
	unsigned char odd[TSD_DSCKEY_MAXLEN];
	unsigned char even_null_flg;
	unsigned char odd_null_flg;
};


/* tsdStartPidDescramble, tsdSopPidDescramble */
struct tsd_desc_pid_arg_t{
	int error;
	unsigned long descentry;
	unsigned short pid;
};

/* tsdGetScrambleStatus */
struct tsd_get_scramble_status_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned short pid;
	unsigned long status;
};

/* tsdGetStc */
struct tsd_get_stc_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long stc_base32;
	unsigned char stc_base1;
	unsigned short stc_ext;
	unsigned char free_run; /* BOOL == UB == unsigned char */
};

/* tsdSetStcFrequency, tsdGetStcFrequency */
struct tsd_stc_freq_arg_t{
	int error;
	unsigned long stcout_port;
	short tendency;
};

struct tsd_set_free_run_stc_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long stcout_port;
};

/* tsdSectionNotify, tsdPespacketNotify, tsdTspacketNotify */
struct tsd_notify_arg_t{
	unsigned long tsin_port;
	unsigned short pid;
	unsigned long pidentry;
	short reqids[TSD_MAX_REQF];
	unsigned short reqnum;
	unsigned char crc;
	tsd_fifo_t fifo;
	void *tag[TSD_MAX_REQF];
};
/* tsdQueryResource */
struct tsd_query_resource_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned char resource_type;
	unsigned char condition;
	unsigned short resource_num;
};

/*
 * tsdStartTsoutput
 */
struct tsd_start_tsoutput_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long tsout_port;
	unsigned char mode;
};

/* tsdSetPatTsoutput */
struct tsd_setpat_arg_t{
	int error;
	unsigned long tsout_port;
	unsigned short pid;
	int pat_shmid;
	unsigned long packet_num;
};

/* tsdSetPmtTsoutput */
struct tsd_setpmt_arg_t{
	int error;
	unsigned long tsout_port;
	unsigned short pid[TSD_PMT_MAXNUM];
	int pmt_shmid[TSD_PMT_MAXNUM];
	unsigned long pmtnum;
	unsigned char multi;
	unsigned long packet_num;
};

/* tsdSetSitTsoutput */
struct tsd_setsit_arg_t{
	int error;
	unsigned long tsout_port;
	unsigned short pid;
	int sit_shmid;
	unsigned long packet_num;
};

/*
 * tsdStopTsoutput, tsdStopPatTsoutput,
 * tsdStopPmtTsoutput, tsdStopSitTsoutput
 */
struct tsd_stop_tsoutput_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long tsout_port;
};

/* tsdSetBufTsoutput */
struct tsd_set_buf_tsoutput_arg_t {
	int error;
	unsigned long tsout_port;
	unsigned long saddr;
	unsigned long eaddr;
	unsigned char loop;
	unsigned long mask;
};

/* tsdUpdateSizeTsoutput */
struct tsd_update_size_tsoutput_arg_t {
	int error;
	unsigned long tsout_port;
	unsigned long size;
};

/* tsdUpdateWaddrTsoutput */
struct tsd_update_waddr_tsoutput_arg_t {
	int error;
	unsigned long tsout_port;
	unsigned long waddr;
};

/* tsdUpdateRaddrTsoutput */
struct tsd_update_raddr_tsoutput_arg_t {
	int error;
	unsigned long tsout_port;
	unsigned long raddr;
};

/* tsdUpdateCaddrTsoutput */
struct tsd_update_caddr_tsoutput_arg_t {
	int error;
	unsigned long tsout_port;
	unsigned long caddr;
};

/* tsdGetBufStatusTsoutput */
struct tsd_get_buf_status_tsoutput_arg_t {
	int error;
	unsigned long tsout_port;
	tsd_buf_t buf;
};


/*
 * tsdStartPatTsoutput
 * tsdStartPmtTsoutput, tsdStartSitTsoutput
 */
struct tsd_start_si_tsoutput_arg_t{
	int error;
	unsigned long tsout_port;
	unsigned char rate;
	unsigned long min_interval;
	unsigned char repeat;
};

/*
 * tsdInsertDitTsoutput
 */
struct tsd_insert_dit_arg_t{
	int error;
	unsigned long tsout_port;
	unsigned char trans;
};

/*
 * tsdRequestTsinputStatus
 */
struct tsd_request_tsi_status_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned long mask;
	short reqid;
};

/*
 * tsdRequestTsoutputStatus
 */
struct tsd_request_tso_status_arg_t{
	int error;
	unsigned long tsout_port;
	unsigned long mask;
	short reqid;
};


/*
 * tsdRequestAvoutputStatus
 */
struct tsd_request_avo_status_arg_t{
	int error;
	unsigned long avout_port;
	unsigned long mask;
	short reqid;
};

/*
 * tsdRequestPidStatus
 */
struct tsd_request_pid_status_arg_t{
	int error;
	unsigned long pidentry;
	unsigned long mask;
	short reqid;
};

/*
 * tsdGetMemorySpoolArea
 */
struct tsd_get_memory_spool_area_arg_t{
	int error;
	unsigned long addr;
	unsigned long length;
};

/*
 * tsdInitMemoryManager
 */
struct tsd_init_memory_manager_arg_t{
	int error;
	unsigned long tsin_port;
};

/*
 * tsdMemTermFunc
 */
struct tsd_mem_term_func_arg_t{
	unsigned long tsin_port;
};

/*
 * tsdMemAllocateFunc
 */
struct tsd_mem_allocate_func_arg_t{
	int error;
	unsigned long tsin_port;
	unsigned short pid;
	unsigned long length;
	unsigned long alignment_mask;
	tsd_fifo_t fifo;
};

/*
 * tsdMemFreeFunc
 */
struct tsd_mem_free_func_arg_t{
	int error;
	unsigned long tsin_port;
	tsd_fifo_t fifo;
};

/*
 * tsdStcNotify
 */
struct tsd_stc_notify_arg_t{
	unsigned long tsin_port;
	unsigned long stc_base;
	unsigned char stc_base0;
};

struct tsd_si_overwrite_notify_arg_t{
	int error;
	unsigned long  tsout_port;  /* output port number */
	unsigned long  event; 		/* event type */
	unsigned short tid_ex;		/* add info */
};

struct tsd_status_notify_arg_t{
	int error;
	unsigned long port; 		/* input port number */
	unsigned long event;		/* event(OR) */
	signed short  reqid; 		/* request ID */
};

struct tsd_pid_status_notify_arg_t{
	int error;
	unsigned long pidentry;		/* pid entry */
	unsigned long event;		/* event(OR) */
	signed short  reqid; 		/* request ID */
};
struct tsd_message_t {
	unsigned long cmd ;
	union { 
		struct tsd_si_overwrite_notify_arg_t	siovw ;
		struct tsd_status_notify_arg_t		status ;
		struct tsd_pid_status_notify_arg_t	pid_status ;
	} args ;
} ;

/* tsdSetStcVideo */
struct tsd_set_stc_video_arg_t{
	int error;
	unsigned long flag;
};

/* tsdSetStcAudio */
struct tsd_set_stc_audio_arg_t{
	int error;
	unsigned long flag;
};

/* tsdSetStcAV */
struct tsd_set_stc_av_arg_t{
	int error;
	unsigned long vflag;
	unsigned long aflag;
};

/* tsdStartStcRecovery, tsdStopStcRecovery */
struct tsd_void_arg_t{
	int error;
};

/* tsdSetTendencyFactors */
struct tsd_set_tendency_factors_arg_t{
	int error;
	unsigned long alpha;
	unsigned long beta;
};

/* tsdStartCcIgnore */
struct tsd_start_cc_ignore_arg_t{
  int error;
  unsigned long pidentry;
};

struct tsd_mbc_notify_arg_t{
	int error;
	unsigned long ts_port;
	unsigned long result;
	tsd_buf_t buf;
};

struct tsd_reset_pktcnt_arg_t{
  int error;
  unsigned long tsout_port;
  unsigned long spn;
};

struct tsd_pktcnt_arg_t{
  int error;
  unsigned long tsout_port;
};

struct tsd_get_pktcnt_arg_t{
  int error;
  unsigned long tsout_port;
  unsigned char type;
  unsigned long spn;
};

struct tsd_reqsi_overwrite_pktcnt_arg_t{
  int error;
  unsigned long tsout_port;
  unsigned char type;
  unsigned long spn;
};

struct tsd_cansi_overwrite_pktcnt_arg_t{
  int error;
  unsigned long tsout_port;
  unsigned char type;
};

struct tsd_req_pktcnt_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned long tsout_port;
  unsigned short pid;
  unsigned char type;
};

struct tsd_can_pktcnt_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned long tsout_port;
  unsigned char type;
};

struct tsd_reqpcr_discon_pktcnt_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned long tsout_port;
  unsigned short pid;
};

struct tsd_canpcr_discon_pktcnt_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned long tsout_port;
};

struct tsd_set_pcr_threshold_pktcnt_arg_t{
  int error;
  unsigned long tsout_port;
  unsigned short threshold;
};

struct tsd_video_pid_cc_ignore_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned short pid;
};

struct tsd_seamless_dummy_arg_t{
  int error;
  unsigned long avout_port;
};

struct tsd_allocate_pid_heddet_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned long tsout_port;
  unsigned short pid;
  unsigned char mode;
  unsigned long hedentry;
};

struct tsd_heddet_arg_t{
  int error;
  unsigned long hedentry;
};

struct tsd_free_pidall_heddet_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned long tsout_port;
};

struct tsd_pktcnt_notify_arg_t{
  unsigned long tsout_port;
  unsigned char type;
  unsigned long spn;
  tsd_fifo_t fifo;
};


struct tsd_heddet_notify_arg_t{
  unsigned long tsout_port;
  unsigned long hedentry;
  unsigned long spn;
  unsigned long pts_base32;
  unsigned long pts_ext;
  unsigned long size;
};

struct tsd_change_stc_recovery_arg_t{
  int error;
  unsigned long tsin_port;
  unsigned char flag;
};

#endif /* TSD_BRIDGE_DATA_H */
